/*****************************************************************************

	Projet	: Pulsar Sample FFT AddOn

	Fichier	: sample_addon.cpp
	Partie	: End

	Auteur	: RM
	Date		: 040597 -- version 0.2 (C funcs)
	Date		: 010797 -- version 0.3 (CFilter)
	Format	: tabs==2

	This Sample FFT Add-on does something : blit the two fft on screen.
	This is a hack.

	The simple way to do this :
	- implement & export the C function "CFilter * filterInit(uint32 index)",
	  where  you simply create your CFilter derived class.
	- derive a class from CFilter, you should at least implement two methods
	- CFilter::load() must be implemented, this is where you will fill info about
	  your add-on, name, auhtor, etc. You DON'T need to call the inherited function,
	  it does nothing.
	- CFilter::processFrame() is where you draw the output, by using the info about
	  the sound and the stream.

*****************************************************************************/

#include "CFilter.h"

#pragma export on
CFilter * filterInit(uint32 index);
#pragma export reset

//--------------------------------------------------------------------

//*************************************
class CSampleCopperBarFilter : public CFilter
//*************************************
{
public:

	CSampleCopperBarFilter(void) : CFilter()	{ /* nothing */ }
	virtual ~CSampleCopperBarFilter(void) 		{ /* nothing */ }

	virtual bool load(void);
	virtual bool prepare(void) { return true; } // don't miss that call !
	virtual void processFrame(void);

}; // end of class defs for CSampleCopperBarFilter


//--------------------------------------------------------------------


//**********************************************
CFilter * filterInit(uint32 index)
//**********************************************
/*
	This function is called when the add-on is loaded.
	This occurs when Pulsar is starting.
	This function is called several times with index=0 then 1 etc
	until it returns NULL. This give you the opportunity to code
	several filters in one add-on.

	Here you must create a new instance of your derived CFilter class.
	You return the pointer on the instance.
	You get called several times until you return NULL.
	You must return a valid object pointer, since the caller will verify
	using ClassInfo that the class is derived from CFilter but is not a
	CFilter instance.
*/
{
	// this add-on only declares ONE filter
	if (index > 0) return NULL;

	CSampleCopperBarFilter *info = new CSampleCopperBarFilter;
	if (!info) return NULL;		// memory error, give up

	// returns the instance -- the caller will check that this instance
	// is derived from CFilter but is _not_ a CFilter...
	return info;
} // end of filterInit


//*******************************
bool CSampleCopperBarFilter::load(void)
//*******************************
/*
	Called just after the add-on has succesfully been loaded.
	If you return false, <the add-on will be unloaded immediatly
	and its unload() hook will be called>.
	Use this to set up the vital info about the filter, i.e. the
	strings (optional) and the supported color mode (currently fixed to 8 bits).
	This can also be done in you class constructor.
	The main difference with the constructor is that when you get here,
	the main program will have set up your main members, like the directories,
	the pointers onto buffers, etc. Also you can get back the index of the
	instance indicated by filterInit here. Check the CFilter.h for more info ;-)
*/
{	sFilter.name = "Copper bar";
	sFilter.author = "SpH^da clubX";
	sFilter.info = "Not anymore a sample CoDe :)";
	sFilter.majorVersion = 0;
	sFilter.minorVersion = 3;
	sFilter.preferredPosition = kFilterPositionFirst;

	return(sLoad.majorPulsarVersion == sFilter.majorVersion
			&& sLoad.minorPulsarVersion == sFilter.minorVersion);
}  // end of load for CSampleCopperBarFilter


//***************************************
void CSampleCopperBarFilter::processFrame(void)
//***************************************
/*
	Real blit into the screen.
	<Updated fields : frame, lastFps>

	Bad implementation, may be *that* slow...

	Warning !
	NO THESE ARE NO LONGER CONSTANT !
	I WIL SWITCH TO DOUBLE BUFFER IN 0.4 !!
*/
{
uchar *base;
long bpr;
long frame;
float *chanL;
float *chanR;
int sy=sPrepare.sy;		if (sy>480) sy=480;
int sx=sPrepare.sx;
int y = 1;
float coul=30;
static float max=0;
float moy = 0;
int ampl = 0;
float coul_ratio=0;
int v_screen = (sy / 2);
int diff = 0;

	base  = sFrame.screen;
	bpr   = sPrepare.bpr;
	frame = sFrame.frame;
	chanL = sFrame.fftHigh;
	chanR = sFrame.fftBass;
	
	if (max==0) max=chanR[2];
	if (max<chanR[2]) max=chanR[2];
	moy = chanR[2]/max;
	ampl = sy*moy;
	coul_ratio = (float)30/(float)ampl;

	if (ampl > v_screen-1) ampl=v_screen-1;
	diff = v_screen - ampl;
/* -- code from SpH

  for (int i=v_screen;i>diff;i--)
  {  	
  	blitLine(1,i,sx,i,(int)coul);
  	coul=coul-coul_ratio;
  }
  coul = 30;
  diff = v_screen + ampl;
  for (int i=v_screen;i<diff;i++)
  {  	
  	blitLine(1,i,sx,i,(int)coul);
  	coul=coul-coul_ratio;
  }
*/

/* -- the same by the R'alf to optimize... get rid of blitLine
*/	

uint32 cols[480];
int i;

  for (i=v_screen;i>diff;i--)
  {
  	uint32 a = coul;
  	a = a & 0xFF;
  	a = a | (a << 8);
  	a = a | (a << 16);
  	cols[i] = a;
  	coul=coul-coul_ratio;
  }

  coul = 30;
  diff = v_screen + ampl;
  for (i=v_screen;i<diff;i++)
  {  	
  	uint32 a = coul;
  	a = a & 0xFF;
  	a = a | (a << 8);
  	a = a | (a << 16);
  	cols[i] = a;
  	coul=coul-coul_ratio;
  }

	int j=v_screen-ampl;
	int i_max = bpr/4/4;
	uint32 *u = (uint32 *)base + j*bpr/4;

	uint32 *ub = (uint32 *)base;
	for(; ub<u; ub++) *ub=0;

	for(; j<diff; j++, u+=bpr/4)
	{
		uint32 a=cols[j];
		uint32 *u2=u;
		for(i=0; i<i_max; i++)
		{
			*(u2++) = a;
			*(u2++) = a;
			*(u2++) = a;
			*(u2++) = a;
		}
	}

	uint32 *ue = (uint32 *)(base+sPrepare.sxy);
	for(; u<ue; u++) *u=0;

}  // end of processFrame for CSampleCopperBarFilter


// eoc
